open Ast

module NameMap = Map.Make(String);;

let library_functions = [
  ("print", TFun([T("A")], TVoid));
  ("print_str", TFun([TString], TVoid));
  ("print_num", TFun([TNum], TVoid));
  ("print_bool", TFun([TBool], TVoid));
  ("print_list", TFun([TList(T("AI"))], TVoid));
  ("print_dict", TFun([TDict(T("AJ"), T("AK"))], TVoid));
  ("to_str", TFun([TNum], TString));
  ("hd", TFun([TList(T("B"))], T("B")));
  ("empty", TFun([TList(T("C"))], TBool));
  ("tl", TFun([TList(T("D"))], TList(T("D"))));
  ("len", TFun([TList(T("E"))], TNum));
  ("filter", TFun([TFun([T("F")],TBool); TList(T("F"));], TList(T("F"))));
  ("map", TFun([TFun([T("G")],T("H")); TList(T("G"));], TList(T("H"))));
  ("foldl", TFun([TFun([T("I"); T("J")], T("I")); T("I"); TList(T("J"))], T("I")));
  ("contains", TFun([TDict(T("K"), T("L")); T("K")], TBool));
  ("del", TFun([TDict(T("M"), T("N")); T("M");], TDict(T("M"), T("N"))));
  ("keys", TFun([TDict(T("O"), T("P"));], TList(T("O"))));
  ("count", TFun([TDict(T("Q"), T("R"))], TNum));
];;

let built_in_functions = List.fold_left
    (fun acc (id, t) -> NameMap.add id t acc)
    NameMap.empty library_functions
;;